'use strict'

entityRegistry['module']['threeDeeArrowStream'] = {
    extendedInfo: {
        displayName: 'Arrow Stream',
        displayGroup: '3D Effects',
    },
    init: (staticConfig) => {
        const {
            seed,
            segments,
            numArrows
        } = { ...staticConfig }

        const rng = new Math.seedrandom(seed)
        const arrows = []
        let up = [0,0,1]
        const fwd = m4.normalize([1,-1,0])
        const right = m4.cross(fwd, up)
        up = m4.cross(right,fwd)
        for (let i = 0; i < numArrows; ++i) {
            const points = []
            for (let j = 0; j < 100; ++j) {
                const offsetScale = .1 + Math.min(j * 1.5, 5)
                const rightOff = (rng()*2-1) * offsetScale * .95
                const upOff = (rng()*2-1) * offsetScale * .95
                const fwdOff = (rng()*2-1) * offsetScale * 0.1
                let p = m4.multiplyVector(fwd, j*20)
                p = m4.addVectors(p, m4.multiplyVector(right, rightOff))
                p = m4.addVectors(p, m4.multiplyVector(up, upOff))
                p = m4.addVectors(p, m4.multiplyVector(fwd, fwdOff))
                points.push(p)
            }
            const first = points[0]
            first[0]+=0.001
            points.unshift(first)
            const splinePoints = pathToSpline(points, segments)
            arrows.push(new ArrowModel(splinePoints))
        }

        return {
            arrows
        }
    },
    staticConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'segments', displayName: 'Segments', type: 'int', defaultValue: 50, triggerInit: true },
        { paramName: 'numArrows', displayName: 'Arrows', type: 'int', defaultValue: 10, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'position', displayName: 'Position', type: 'float3', defaultValue: [0, 0, 0]},
        { paramName: 'rotation', displayName: 'Rotation', type: 'angle3', defaultValue: [0, 0, 0]},
        { paramName: 'scale', displayName: 'Scale', type: 'float', defaultValue: 1},
        { paramName: 'animation', displayName: 'Animation', type: 'float', defaultValue: 0},
        { paramName: 'length', displayName: 'Length', type: 'float', defaultValue: 20},
        { paramName: 'arrowWidth', displayName: 'Arrow Width', type: 'float', defaultValue: 1},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                position,
                rotation,
                scale,
                animation,
                length,
                arrowWidth,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')

            const xRotationMat = m4.xRotation(rotation[0])
            const yRotationMat = m4.yRotation(rotation[1])
            const zRotationMat = m4.zRotation(rotation[2])
            const rotationMat = m4.multiply(m4.multiply(zRotationMat, yRotationMat), xRotationMat)
            const scaleMat = m4.scaling(scale, scale, scale)
            const translationMat = m4.translation(position[0], position[1], position[2])
            const worldMat = m4.multiply(translationMat, m4.multiply(rotationMat, scaleMat))

            const animationPos = animation
            let c = 0
            self.arrows.forEach(arrow => {
                const spread = 0//c
                arrow.reset()
                const start = Math.max(0, animationPos+spread-length)
                // arrow.addObject(c, Math.max(start-10, 0), Math.max(start-5, 0),
                //     (a,t) => .2,//Math.sin(c+t*84)*.1+.12,
                //     (a,t) => .2,//Math.sin(c+t*54)*.1+.12,
                // )
                arrow.addObject(c, start, animationPos+spread,
                    (a,t) => .2*arrowWidth,
                    (a,t) => .2*arrowWidth,
                    true, .4*arrowWidth, .4*arrowWidth, 2
                )
                c++
                renderer.drawModel(arrow.getModel(), worldMat, colorBuffer, depthBuffer, brightnessBuffer)
            })
        }
    }
}
